var net = require("net");
const WebSocket = require('ws');
var fs = require('fs');

/////////////////////////////
// update for your xbox ip //
/////////////////////////////
var host = "192.168.1.83";
/////////////////////////////

///////////////////////////////////////////////
//change num if multiple bridges on one comp //
///////////////////////////////////////////////
var wsPort = 51210;
///////////////////////////////////////////////
var updateFreq = 50;
var maxInFlightWrites = 0x20;
var maxPendingPriority = 1;
var stripNulls = true;
var dropOldMovement = true;
var combineRes = true;
var combineSprays = true;
var holdMidCycleMessages = true;

function processFuncInit() {
	console.log("init handoff");
	processFunc = processFuncReadStart;
	return true;
}

var commBufferAddr = 0x288630;
var commBufferLines = 256;
var recvBufferAddr = commBufferAddr;
var sendBufferAddr = recvBufferAddr + (commBufferLines * 0x10);

var recvBufferIdx = 0;
var recvBufferAckIdx = 0;
var sendBufferIdx = 0;

var sendQueue = [];
var recvQueue = [];
var heldQueue = [];

var processFunc = processFuncInit;
var readBuffer = Buffer.from([]);
//var writeLine = Buffer.alloc(16);
//var writePos = 0;
//var inFlightWrites = 0;

var recordState = 0;
var recordTime = 0;
var recorded = [];

var sleeping = false;

var xbox = new net.Socket();
xbox.connect(23, host, function() {
	console.log("connected");
});

function runProcessing() {
	sleeping = false;
	var cont = false;
	do {
		cont = processFunc();
	} while(cont);
}

xbox.on("data", function(data) {
	console.log("recv: " + data.length);
	console.log(data.toString("hex"));
	readBuffer = Buffer.concat([readBuffer, data]);
	if(sleeping == false) {
		runProcessing();
	}
});

xbox.on("close", function() {
	console.log("closed");
});

function recvSpaceUsable() {
	var idx = recvBufferIdx;
	if(idx < recvBufferAckIdx) {
		idx += 256;
	}
	// in_use gets +1 as we cannot write ack -1 position as itd push idx to == acks
	var in_use = idx - recvBufferAckIdx + 1
	return 256 - in_use;
}

var endlineDot = Buffer.from([0x0a, 0x0d, 0x2e]);
var compInitConst = Buffer.from([0xff, 0xfd, 0x01, 0xff, 0xfd, 0x03]);
var enterSend = Buffer.from([0x0d, 0x0a]);
var spaceColonSpace = Buffer.from([0x20, 0x3a, 0x20]);
var spaceBarSpace = Buffer.from([0x20, 0x7c, 0x20]); // 2 spaces in front actually

function processFuncNoTask() {
	return false;
}

function processFuncReadStart() {
	//console.log("sze " + readBuffer.length);
	if(readBuffer.length > 6) {
		var i = readBuffer.indexOf(endlineDot, 6);
		//console.log("ind " + i);
		if(i != 0) {
			var welcome = readBuffer.slice(6, i);
			console.log("Connected to: " + welcome.toString());
			readBuffer = Buffer.from(readBuffer.slice(i + 3));
			xbox.write(compInitConst);
			processFunc = processFuncPreloadScheduler;
			return true;
		}
	}
	return false;
}

var priorityQueued = [];
var secondaryQueued = [];
var pendingCallbacks = [];
var pendingPriority = 0;

function processFuncPreloadScheduler() {
	// check acks
	if(recvBufferAckIdx != recvBufferIdx) {
		priorityQueued.push(queuedAckCheck(recvBufferAckIdx));
	}
	
	// check for sends
	priorityQueued.push(queuedSendCheck(sendBufferIdx));
	// todo: safty checks on sends
	
	recvQueue = recvQueue.concat(heldQueue);
	heldQueue = [];
	
	processFunc = processFuncScheduler;
	return true;
}

function queuedAckCheck(idx) {
	return function() {
		var nextAddr = recvBufferAddr + (idx * 0x10);
		var reqString = "db " + nextAddr.toString(16) + " 10";
		var req = Buffer.from(reqString, "ascii");
		
		xbox.write(req);
		xbox.write(enterSend);
		
		console.log("ackcheck" + idx);
		
		pendingPriority++;
		
		return function(result) {
			var hexStart = result.indexOf(spaceColonSpace);
			//var end = result.indexOf(endlineDot, hexStart);
			var hexEnd = result.indexOf(spaceBarSpace, hexStart);
			var hexString = result.slice(hexStart + 3, hexEnd).toString("ascii").split(" ").join("");
			var hexBuffer = Buffer.from(hexString, "hex");
			
			if(hexBuffer[0] == 0) {
				console.log("ack" + idx);
				recvBufferAckIdx = (idx + 1) & 0xFF;
				
				if(recvBufferAckIdx != recvBufferIdx) {
					priorityQueued.push(queuedAckCheck(recvBufferAckIdx));
				}
			}
			else {
				console.log("noack" + idx);
			}
			
			pendingPriority--;
		};
	};
}

function queuedSendCheck(idx) {
	return function() {
		var nextAddr = sendBufferAddr + (idx * 0x10);
		var reqString = "db " + nextAddr.toString(16) + " 10";
		var req = Buffer.from(reqString, "ascii");
		
		xbox.write(req);
		xbox.write(enterSend);
		
		console.log("reqsends" + idx);
		
		pendingPriority++;
		
		return function(result) {
			var hexStart = result.indexOf(spaceColonSpace);
			var hexEnd = result.indexOf(spaceBarSpace, hexStart);
			var hexString = result.slice(hexStart + 3, hexEnd).toString("ascii").split(" ").join("");
			var hexBuffer = Buffer.from(hexString, "hex");
			
			if(hexBuffer[0] == 1) {
				var line = {};
				line.cat = hexBuffer[1];
				line.sub = hexBuffer[2];
				line.b = hexBuffer[3];
				line.dw1 = hexBuffer.readInt32LE(0x4);
				line.dw2 = hexBuffer.readInt32LE(0x8);
				line.dw3 = hexBuffer.readInt32LE(0xC);
				
				var jsonLine = JSON.stringify(line);
				
				sendQueue.push(jsonLine);
				
				secondaryQueued.push(queuedSendAck(idx));
				
				var nextIdx = (idx + 1) & 0xFF;
				// todo: safty checks on sends
				priorityQueued.push(queuedSendCheck(nextIdx));
			}
			
			pendingPriority--;
		};
	};
}

function queuedSendAck(idx) {
	return function() {
		var nextAddr = sendBufferAddr + (idx * 0x10);
		
		var reqString = "poke " + nextAddr.toString(16) + " 00";
		var req = Buffer.from(reqString, "ascii");
		
		xbox.write(req);
		xbox.write(enterSend);
		
		return function(result) {
			sendBufferIdx = (idx + 1) & 0xFF;
		};
	};
}

function queuedRecvWrite(addr, value) {
	return function() {
		var reqString = "poke " + addr.toString(16) + " " + value.toString("hex");
		var req = Buffer.from(reqString, "ascii");
		
		xbox.write(req);
		xbox.write(enterSend);
		
		if((addr & 0x0F) == 0) {
			recvBufferIdx = (recvBufferIdx + 1) & 0xFF;
		}
		
		return function(result) {
		};
	};
}

function prepRecvWrites() {
	var nextAddr = recvBufferAddr + (recvBufferIdx * 0x10);
	
	var next = recvQueue.shift();
	var writeLine = Buffer.alloc(16);
	writeLine[0] = 1;
	writeLine[1] = next.cat;
	writeLine[2] = next.sub;
	writeLine[3] = next.b;
	writeLine.writeInt32LE(next.dw1, 0x4);
	writeLine.writeInt32LE(next.dw2, 0x8);
	writeLine.writeInt32LE(next.dw3, 0xC);
	
	console.log("writing" + recvBufferIdx);
	
	var i;
	for(i = 15; i >= 0; i--) {
		if(stripNulls == true || writeLine[i] != 0) {
			secondaryQueued.push(queuedRecvWrite(nextAddr + i, writeLine.slice(i, i + 1)));
		}
	}
}

function dropQueuedOldMovement() {
	var done = false;
	while(recvQueue.length != 0 && recvQueue[0].cat == 3 && done == false) {
		var sub = recvQueue[0].sub;
		var b = recvQueue[0].b;
		
		var found = false;
		var i;
		for(i = 1; i < recvQueue.length; i++) {
			if(recvQueue[i].cat == 3
				&& recvQueue[i].sub == sub
				&& recvQueue[i].b == b) {
				
				found = true;
			}
		}
		
		if(found) {
			recvQueue.shift();
		}
		else {
			done = true;
		}
	}
}

function combineQueuedRes() {
	// we assume we already checked theres an element
	if(recvQueue[0].cat == 1) {
		var resType = recvQueue[0].sub;
		var i = 1;
		while(i < recvQueue.length) {
			if(recvQueue[i].cat == 1 && recvQueue[i].sub == resType) {
				recvQueue[0].dw1 += recvQueue[i].dw1;
				recvQueue.splice(i, 1);
			}
			else {
				i++;
			}
		}
	}
}

function combineQueuedSprays() {
	// we assume we already checked theres an element
	if(recvQueue[0].cat == 2 && recvQueue[0].sub == 0) {
		var op = recvQueue[0].b;
		var area = recvQueue[0].dw1;
		var spray = recvQueue[0].dw2;
		
		var i = 1;
		var done = false;
		while(i < recvQueue.length && done == false) {
			if(recvQueue[i].cat == 2
				&& recvQueue[i].sub == 0
				&& recvQueue[i].dw1 == area
				&& recvQueue[i].dw2 == spray) {
				
				if(recvQueue[i].b == op) {
					if(op == 0) {
						recvQueue[0].dw3 &= recvQueue[i].dw3;
					}
					else if(op == 1) {
						recvQueue[0].dw3 |= recvQueue[i].dw3;
					}
					else {}
					
					recvQueue.splice(i, 1);
				}
				else {
					// different op, abort
					done = true;
				}
			}
			else {
				i++;
			}
		}
	}
}

function refillSecondaryQueue() {
	if(secondaryQueued.length == 0 && recvQueue.length != 0) {
		if(dropOldMovement) {
			dropQueuedOldMovement();
		}
		if(combineRes) {
			combineQueuedRes();
		}
		if(combineSprays) {
			combineQueuedSprays();
		}
		prepRecvWrites();
	}
}

function processFuncScheduler() {
	var endResponse = readBuffer.indexOf(endlineDot);
	while(pendingCallbacks.length != 0 && endResponse != -1) {
		var response = readBuffer.slice(0, endResponse + 3);
		readBuffer = Buffer.from(readBuffer.slice(endResponse + 3));
		
		var callback = pendingCallbacks.shift();
		callback(response);
		
		var endResponse = readBuffer.indexOf(endlineDot);
	}
	
	while(priorityQueued.length != 0 && pendingPriority < maxPendingPriority && pendingCallbacks.length < maxInFlightWrites) {
		var f = priorityQueued.shift();
		pendingCallbacks.push(f());
	}
	
	while((secondaryQueued.length != 0 || (recvQueue.length != 0 && recvSpaceUsable() != 0)) && pendingCallbacks.length < maxInFlightWrites) {
		// technically ack writing does not need open recv space, but probably not worth worrying about that case
		refillSecondaryQueue();
		
		var f = secondaryQueued.shift();
		pendingCallbacks.push(f());
	}
	
	// warning: double check if this is ok to leave queue items and end if theses backlog
	
	if(pendingCallbacks.length != 0) {
		return false;
	}
	else {
		processFunc = processFuncPeerSend;
		return true;
	}
}

function processFuncPeerSend() {
	if(sendQueue.length != 0 && hasWSConnection()) {
		if(recordState == 1) {
			var rec = {
				t: (Date.now() - recordTime),
				r: [...sendQueue]
			};
			recorded.push(rec);
		}
		while(sendQueue.length != 0) {
			var line = sendQueue.shift();
			if (line.slice(7,8) != "1") {
				wss.clients.forEach(function (client){
					if(client.readyState === WebSocket.OPEN) {
						client.send(line);
					}
				});
			} else {
				console.log("blocked can send");
			} 
			//console.log("sent");
		}
	}
	
	processFunc = processFuncPreloadScheduler;
	sleeping = true;
	setTimeout(runProcessing, updateFreq);
}

const wss = new WebSocket.Server({
	port: wsPort
});

wss.on("connection", function(ws){
	console.log("websocket connected");
	ws.on("message", function(data){
		//console.log("received: " + data);
		
		var parsed = JSON.parse(data);
		if(holdMidCycleMessages) {
			heldQueue.push(parsed);
		}
		else {
			recvQueue.push(parsed);
		}
		
		if(parsed.cat == 0 && parsed.sub == 8) {
			if(parsed.b == 0 && recordState == 1) {
				recordState = 0;
				var recString = JSON.stringify(recorded);
				fs.writeFile("inputReplay", recString, (err) => {
					if(err) {
						console.log(err);
					}
				});
			}
			else if(parsed.b == 1 && recordState == 0) {
				recordState = 1;
				recordTime = Date.now();
				recorded = [];
			}
		}
	});
	ws.on("close", function(){
		console.log("websocket disconnected");
	});
});

function hasWSConnection() {
	var con = 0;
	wss.clients.forEach(function(client){
		if(client.readyState === WebSocket.OPEN) {
			con++;
		}
	});
	return con != 0;
}
